#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct Jarbol {
    int x;
    int h;
    int i;
};

int main() {
    int n;
    cin >> n;

    vector<Jarbol> J(n);
    for (int i = 0; i < n; i++) {
        cin >> J[i].x;
        J[i].i = i;
    }
    for (int i = 0; i < n; i++) {
        cin >> J[i].h;
    }

    sort(J.begin(), J.end(),
        [](const Jarbol& a, const Jarbol& b) {
            return a.x < b.x;
        }
    );

    vector<int> odg(n, -1);

    vector<int> s;

    for (int i = 0; i < n; i++) {
        while (!s.empty() && J[s.back()].h < J[i].h) {
            s.pop_back();
        }

        if (!s.empty()) {
            odg[J[i].i] = (J[i].x + J[i].h) - (J[s.back()].x + J[s.back()].h);
        }

        s.push_back(i);
    }

    s.clear();

    for (int i = n - 1; i > -1; i--) {
        while (!s.empty() && J[s.back()].h < J[i].h) {
            s.pop_back();
        }

        if (!s.empty()) {
            int d = (J[s.back()].x - J[s.back()].h) - (J[i].x - J[i].h);
            int o = odg[J[i].i];
            if (o == -1 || d < o) {
                odg[J[i].i] = d;
            }
        }

        s.push_back(i);
    }

    for (int i = 0; i < n; i++) {
        cout << odg[i] << '\n';
    }
}